using System.Collections;
using System.Collections.Generic;
using System.IO;
using UnityEngine;
using Hive.Unity.Editor;

public class HivePostProcessDefaultSettingIOS {
    public readonly bool isAddPushNotifications = true;
    public readonly bool isPushNotificationsDevelopment = true;
    public readonly bool hasPushNotificatonMediaContents = false;
    public readonly bool hasPushNotificatonActionButtons = false;
    public List<string> pushNotificatonActionButtonCategories {
        get { return pushCategoriesFromJson(); }
    }
    public readonly bool isAddBackGroundModesRemoteNotifications = true;
    public readonly bool isAddSignInWithApple = false;
    public readonly bool isAddGameCenter = ExternalDependencyDictionaryManager.isUseDependency(ExternalDependencyDictionaryManager.SupportOSType.iOS, ExternalDependencyType.Apple);
    public readonly bool isAddInAppPurchase = true;
    public readonly bool isAddAssociatedDomains = false;
    public readonly List<string> associatedDomains = new List<string> {"applinks:hiveota.withhive.com", 
                                                    "applinks:promotion.qpyou.cn", 
                                                    "applinks:test-promotion.qpyou.cn", 
                                                    "applinks:sandbox-promotion.qpyou.cn",
                                                    "applinks:direct-link.withhive.com",
                                                    "applinks:test-direct-link.withhive.com",
                                                    "applinks:sandbox-direct-link.withhive.com",};
    /*// GoogleService-Info.plist
    public readonly bool isAddGoogleServiceInfoPlist = true;
    public readonly string googleServiceInfoPlistFilePath = "Assets/ExternalResources/iOS";
    */

    private List<string> pushCategoriesFromJson()
    {
        List<string> allCategories = new();
        string path = "Assets/Plugins/iOS/hive_push_actions.json";

        try
        {
            if (!File.Exists(path)) return allCategories;

            string jsonStr = File.ReadAllText(path);

            var root = MiniJSON.Json.Deserialize(jsonStr) as Dictionary<string, object>;

            if (root.TryGetValue("categories", out var categoriesObj) && categoriesObj is Dictionary<string, object> categories)
                foreach (var key in categories.Keys)
                    allCategories.Add(key);

            return allCategories;
        }
        catch (System.Exception e)
        {
            HiveLogger.LogError(e.ToString());

            return allCategories;
        }
    }
}